using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web.Mvc;
using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.ViewModels.HpiiSearch
{
    public class SearchByDemographicsViewModel : IValidatableObject
    {
        #region Properties

        [Required]
        [Display(Name = "Organisation (HPI-O)")]
        public string Hpio { get; set; }

        [Required, StringLength(40, ErrorMessage = "Family Name must be less than 40 characters long.")]
        [Display(Name = "Family Name")]
        public string FamilyName { get; set; }

        [StringLength(100, ErrorMessage = "Given Name(s) must be less than 100 characters long.")]
        [Display(Name = "Given Name(s)")]
        public string GivenNames { get; set; }

        [Required, Display(Name = "Sex")]
        public string SexCode { get; set; }

        [Required, Display(Name = "Date of Birth"), DisplayFormat(DataFormatString = "dd/MM/yyyy")]
        public DateTime? DateOfBirth { get; set; }

        public AustralianAddressViewModel AustralianAddress { get; set; }

        public InternationalAddressViewModel InternationalAddress { get; set; }

        public ResponseMessages ResponseMessages { get; internal set; }

        #endregion

        #region Data Source Properties

        public IEnumerable<SelectListItem> Hpios { get; internal set; }
        public IEnumerable<SelectListItem> Sexes { get; internal set; }

        public IEnumerable<SelectListItem> UnitTypes
        {
            get { return AustralianAddress.UnitTypes; }
            internal set { AustralianAddress.UnitTypes = value; }
        }

        public IEnumerable<SelectListItem> LevelTypes
        {
            get { return AustralianAddress.LevelTypes; }
            internal set { AustralianAddress.LevelTypes = value; }
        }

        public IEnumerable<SelectListItem> StreetTypes
        {
            get { return AustralianAddress.StreetTypes; }
            internal set { AustralianAddress.StreetTypes = value; }
        }

        public IEnumerable<SelectListItem> StreetSuffixes
        {
            get { return AustralianAddress.StreetSuffixes; }
            internal set { AustralianAddress.StreetSuffixes = value; }
        }

        public IEnumerable<SelectListItem> PostalDeliveryTypes
        {
            get { return AustralianAddress.PostalDeliveryTypes; }
            internal set { AustralianAddress.PostalDeliveryTypes = value; }
        }

        public IEnumerable<SelectListItem> States
        {
            get { return AustralianAddress.States; }
            internal set { AustralianAddress.States = value; }
        }

        public IEnumerable<SelectListItem> Countries
        {
            get { return InternationalAddress.Countries; }
            internal set { InternationalAddress.Countries = value; }
        }

        #endregion

        /// <summary>
        ///     Initialises a new SearchByDemographicsViewModel without reference data.
        /// </summary>
        /// <remarks>
        ///     Called automatically by MVC Model Binding.
        ///     Should initialise collections and complex objects to default/empty values.
        /// </remarks>
        public SearchByDemographicsViewModel()
        {
            AustralianAddress = new AustralianAddressViewModel();
            InternationalAddress = new InternationalAddressViewModel();
            Hpios = Enumerable.Empty<SelectListItem>();
            Sexes = Enumerable.Empty<SelectListItem>();
            ResponseMessages = new ResponseMessages();
        }

        /// <summary>
        ///     Determines whether the specified object is valid.
        /// </summary>
        /// <returns>
        ///     A collection that holds failed-validation information.
        /// </returns>
        /// <param name="validationContext">The validation context.</param>
        /// <remarks>
        ///     Executed server-side after all annotation validators are successful.
        /// </remarks>
        public IEnumerable<ValidationResult> Validate(ValidationContext validationContext)
        {
            List<ValidationResult> errors = new List<ValidationResult>();

            if (!AustralianAddress.HasAnyValue() && !InternationalAddress.HasAnyValue())
            {
                errors.Add(new ValidationResult("Please provide either an Australian Address or an International Address."));
            }

            if (AustralianAddress.HasAnyValue() && InternationalAddress.HasAnyValue())
            {
                errors.Add(new ValidationResult("Please provide only one of an Australian Address or an International Address."));
            }

            return errors;
        }
    }
}